﻿using UnityEngine;
using UnityEngine.UI;
using System.Collections;

public class SubtitleShowerScript : MonoBehaviour {

	private static Text uiText;

	/*Opcje dodatkowe
	private static Image uiImage;
	private static Text uiName;
	*/

	const float defaultDuration = 5f;

	// W tej funkcji zainicjuj zmienne
	void Start () {
		uiText = GetComponentInChildren<Text> ();

        /*Opcje dodatkowe
		uiImage = GetComponentInChildren<Image> ();
		
		uiName = GameObject.Find("SubtitleShowerCharactername").GetComponent<Text> ();
		uiText = GameObject.Find("SubtitleShowerText").GetComponent<Text> ();
		*/


    }

    public static IEnumerator show(string subtitle, float duration = defaultDuration, AudioClip clip = null){
		uiText.text = subtitle;
		if (clip) {
			AudioSource.PlayClipAtPoint (clip, Input.mousePosition);
			yield return new WaitForSeconds (clip.length);
		} else {
			yield return new WaitForSeconds (duration);
		}
		uiText.text = "";
	}

    /* Opcje dodatkowe:
	public static IEnumerator show(string subtitle, float duration = defaultDuration, AudioClip clip = null, Sprite icon = null, string name = ""){
		uiName.text = name;
		uiImage.sprite = icon;
		uiText.text = subtitle;
		if (clip) {
			AudioSource.PlayClipAtPoint (clip, Input.mousePosition);
			yield return new WaitForSeconds (clip.length);
		} else {
			yield return new WaitForSeconds (duration);
		}
		uiText.text = "";
		uiImage.sprite = null;
		uiName.text = "";
	}*/
}
